/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.VLANEvent;
import apiipc.generated.events.VLANEventListener;
import apiipc.generated.sim.VLAN;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLANEventRegistry
extends IPCEventRegistry {
    protected Set<VLANEventListener> globalListeners = new HashSet<VLANEventListener>();
    protected Map<String, Set<VLANEventListener>> specificObjectListeners = new HashMap<String, Set<VLANEventListener>>();

    public VLANEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "VLAN";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        VLANEvent vLANEvent = null;
        if (string.equalsIgnoreCase("macEntryAdded")) {
            vLANEvent = new VLANEvent.MacEntryAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("macEntryRemoved")) {
            vLANEvent = new VLANEvent.MacEntryRemoved(iPCEventLTV);
        } else {
            return;
        }
        for (VLANEventListener object : this.globalListeners) {
            object.handleEvent(vLANEvent);
        }
        System.out.println("UUID = " + vLANEvent.objectUUID);
        Set<VLANEventListener> set = this.specificObjectListeners.get(vLANEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                VLANEventListener vLANEventListener = (VLANEventListener)iterator.next();
                vLANEventListener.handleEvent(vLANEvent);
            }
        }
    }

    public void addListenerFiltered(VLANEventListener vLANEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("macEntryAdded");
                this.register("macEntryRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(vLANEventListener);
    }

    public void addSpecificListenerFiltered(VLANEventListener vLANEventListener, VLAN vLAN, List<String> list) throws IOException {
        UUID uUID = vLAN.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<VLANEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<VLANEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "macEntryAdded");
                this.register(uUID, "macEntryRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(vLANEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(VLANEventListener vLANEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("macEntryAdded");
                this.deregister("macEntryRemoved");
                this.globalListeners.remove(vLANEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(VLANEventListener vLANEventListener, VLAN vLAN, List<String> list) throws IOException {
        UUID uUID = vLAN.getObjectUUID();
        String string = uUID.toString();
        Set<VLANEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "macEntryAdded");
                this.deregister(uUID, "macEntryRemoved");
                set.remove(vLANEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(VLANEventListener vLANEventListener) throws IOException {
        this.addListenerFiltered(vLANEventListener, null);
    }

    public void addListener(VLANEventListener vLANEventListener, VLAN vLAN) throws IOException {
        this.addSpecificListenerFiltered(vLANEventListener, vLAN, null);
    }

    public void removeListener(VLANEventListener vLANEventListener) throws IOException {
        this.removeListenerFiltered(vLANEventListener, null);
    }

    public void removeListener(VLANEventListener vLANEventListener, VLAN vLAN) throws IOException {
        this.removeSpecificListenerFiltered(vLANEventListener, vLAN, null);
    }
}

